import { Marker } from "react-leaflet/Marker"
import { otpGraphql } from "@/services/otp";
import { TODO } from "@/types/utility";
import useSWR from "swr";
import { Popup } from "react-leaflet/Popup";
import { useSetAppSearch } from "../routes/app-route.hooks";
import { Button } from "../ui/form/button";

const STOPS_KEY = "MAP_STOPS_KEY"
export function MapStops() {
    const { data, isLoading, error } = useSWR([STOPS_KEY], () => {
        return otpGraphql.stops()
    }, {
        revalidateOnFocus: false,
        revalidateOnMount: false,
        revalidateOnReconnect: false,
    })

    if (isLoading || error || !data) {
        return;
    }

    return (
        <>
            {data?.data?.stops.map((s: TODO) => {
                return (
                    <Stop
                        key={`${s.id}`}
                        s={s}
                    />
                )
            })}
        </>
    )
}

function Stop({ s }: TODO) {
    const { setFrom, setTo } = useSetAppSearch()

    return (
        <Marker
            // icon={
            //     new Icon(MAP_ASSETS.marker.end)
            // }
            position={[s.lat, s.lon,]}
        >
            <Popup>
                {s.name}
                <br />
                <Button
                    variant={"ghost"}
                    size={"sm"}
                    className="w-full"
                    onClick={() => setFrom({ latlng: [s.lat, s.lon], key: `${s.name}` })}
                >FROM</Button>
                <br />
                <Button
                    variant={"ghost"}
                    onClick={() => setTo({ latlng: [s.lat, s.lon], key: `${s.name}` })}
                    size={"sm"}
                    className="w-full"
                >TO</Button>
            </Popup>
        </Marker>

    )
}